<?php

class XMLWPQueryTest extends WP_UnitTestCase
{

    /**
     * Test if setXml is called
     */
    function test_setup_set_xml_called()
    {
        $xml_wp_query = $this->getMockBuilder('\XML_WP_Query')
            ->setMethods(array('__construct', 'getXml', 'query'))
            ->setConstructorArgs(array(''))
            ->disableOriginalConstructor()
            ->getMock();
        $xml_wp_query->expects($this->once())->method('getXml');
        $xml_wp_query->setup('', 'http://www.w3schools.com/xml/note.xml');
    }

    /**
     * Test if query is called when a query is given
     */
    function test_setup_query_called_when_query_given()
    {
        $xml_wp_query = $this->getMockBuilder('\XML_WP_Query')
            ->setMethods(array('__construct', 'getXml', 'query'))
            ->setConstructorArgs(array(''))
            ->disableOriginalConstructor()
            ->getMock();
        $xml_wp_query->expects($this->once())->method('query');
        $xml_wp_query->setup('p=1', 'http://www.w3schools.com/xml/note.xml');
    }

    /**
     * Test if query is called when a query is given
     */
    function test_setup_query_not_called_when_query_not_given()
    {
        $xml_wp_query = $this->getMockBuilder('\XML_WP_Query')
            ->setMethods(array('__construct', 'getXml', 'query'))
            ->setConstructorArgs(array(''))
            ->disableOriginalConstructor()
            ->getMock();
        $xml_wp_query->expects($this->never())->method('query');
        $xml_wp_query->setup('', 'http://www.w3schools.com/xml/note.xml');
    }

    /**
     * Test if an exception is thrown when item tag is not defined in options page
     */
    function test_get_posts_throw_exception_when_item_tag_not_defined()
    {
        $xml_wp_query = $this->getMockBuilder('\XML_WP_Query')
            ->setMethods(array('__construct'))
            ->setConstructorArgs(array(''))
            ->disableOriginalConstructor()
            ->getMock();
        try {
            $xml_wp_query->get_posts();//if this method not throw exception it must be fail too.
            $this->fail("Expected exception not thrown");
        } catch (Exception $e) {
            $this->assertEquals(__('XML WP_Query - Item tag is required', 'xml-wp-query'), $e->getMessage());
        }
    }
}

