<?php
/*
Plugin Name: XML WP_Query
Plugin URI:  http://www.yndenz.com
Description: Query an XML feed the same way as using WP_Query
Version:     2.6.2
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: xml-wp-query
*/

defined('ABSPATH') or die('No script kiddies please!');

if (!defined('XML_WP_QUERY_FEED_URL_PROBLEM')) {
    define('XML_WP_QUERY_NO_FEED_URL', 404);
    define('XML_WP_QUERY_CACHE_PROBLEM', 409);
    define('XML_WP_QUERY_READ_XML_PROBLEM', 410);
    define('XML_WP_QUERY_FEED_URL_PROBLEM', 503);
}

require_once dirname(__FILE__) . '/XML_WP_Query.class.php';
require_once dirname(__FILE__) . '/XML_WP_Query_Settings.class.php';

/**
 * Load the text domain for the XML WP_Query plugin
 */
add_action('plugins_loaded', 'xml_wp_query_load_textdomain');
function xml_wp_query_load_textdomain()
{
    load_plugin_textdomain('xml-wp-query', FALSE, basename(dirname(__FILE__)) . '/languages/');
}

/**
 * Force update the cache
 * Used by the button "update now" in the XML WP_Query Settings page
 */
add_action('wp_ajax_xml_wp_query_update_cache', 'xml_wp_query_update_cache');
add_action('wp_ajax_nopriv_xml_wp_query_update_cache', 'xml_wp_query_update_cache');
function xml_wp_query_update_cache()
{
    try {
        new XML_WP_Query($_POST['id'], '', true);
        echo get_post_meta($_POST['id'], 'xml_wp_query_cache_last_update', true);
    } catch (Exception $e) {
        echo $e->getMessage();
        if (WP_DEBUG) {
            var_dump($e->getTrace());
        }
    }
    exit;
}

/**
 * Returns an array representation of a DOMNode
 *
 * @param DOMDocument $dom
 * @param DOMNode $node
 * @return array
 */
function node_to_array($dom, $node)
{
    // Return false if $dom is not a DOM element
    if (!is_a($dom, 'DOMDocument') || !is_a($node, 'DOMNode')) {
        return false;
    }
    $array = [];

    // Discard empty nodes
    $localName = trim($node->localName);
    if (empty($localName)) {
        return false;
    }

    if (XML_TEXT_NODE == $node->nodeType) {
        return [$node->nodeValue];
    }

    foreach ($node->attributes as $attr) {
        $array['@' . $attr->localName] = $attr->nodeValue;
    }

    foreach ($node->childNodes as $childNode) {
        if (1 == $childNode->childNodes->length && XML_TEXT_NODE == $childNode->firstChild->nodeType) {
            $array[$childNode->localName] = $childNode->nodeValue;
        } else {
            if (false !== ($a = node_to_array($dom, $childNode))) {
                $array[$childNode->localName] = $a;
            }
        }
    }
    return $array;
}

add_action('plugins_loaded', 'register_xml_wp_query_settings');
function register_xml_wp_query_settings() {
    $_GLOBALS['XML_WP_Query_Settings'] = new XML_WP_Query_Settings();
}
