<?php

class XML_WP_Query_Settings {

    /**
     * Start up
     */
    public function __construct() {
        add_action('init', array($this, 'register_feed'));
        add_action('admin_init', array($this, 'register_cache'));
    }

    /**
     * Register and add settings
     */
    public function register_feed() {
        register_post_type('xml_wp_query_feed', array(
            'labels' => array(
                'name' => _x('XML Feeds', 'post type general name', 'xml-wp-query'),
                'singular_name' => _x('XML Feed', 'post type singular name', 'xml-wp-query'),
                'menu_name' => _x('XML Feeds', 'admin menu', 'xml-wp-query'),
                'name_admin_bar' => _x('XML Feed', 'add new on admin bar', 'xml-wp-query'),
                'add_new' => _x('Add new', 'feed', 'xml-wp-query'),
                'add_new_item' => __('Add new XML feed', 'xml-wp-query'),
                'new_item' => __('New XML feed', 'xml-wp-query'),
                'edit_item' => __('Edit XML feed', 'xml-wp-query'),
                'view_item' => __('View XML feed', 'xml-wp-query'),
                'all_items' => __('All XML feeds', 'xml-wp-query'),
                'search_items' => __('Search XML feeds', 'xml-wp-query'),
                'not_found' => __('No XML feeds found.', 'xml-wp-query'),
                'not_found_in_trash' => __('No XML feeds found in Trash.', 'xml-wp-query')
            ),
            'description' => __('XML WP_Query feeds', 'xml-wp-query'),
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_icon' => 'dashicons-editor-justify',
            'capability_type' => 'post',
            'has_archive' => false,
            'hierarchical' => false,
            'supports' => array('title')
        ));

        if (function_exists("register_field_group")) {
            register_field_group(array(
                'id' => 'acf_feed',
                'title' => __('XML Feed', 'xml-wp-query'),
                'fields' => array(
                    array(
                        'key' => 'field_562a159a6cc4f',
                        'label' => __('Feed URL', 'xml-wp-query'),
                        'name' => 'xml_wp_query_feed_url',
                        'type' => 'text',
                        'required' => 0,
                        'default_value' => '',
                        'placeholder' => '',
                        'instructions' => __('Leave empty if you force using a local feed.', 'xml-wp-query'),
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_262a15d36cc49',
                        'label' => __('Cleanup query', 'xml-wp-query'),
                        'name' => 'xml_wp_query_cleanup_query',
                        'type' => 'text',
                        'required' => 0,
                        'default_value' => '',
                        'placeholder' => '',
                        'instructions' => __('Specify which tags have to be removed from the XML to clean up the feed and speed up the queries.', 'xml-wp-query'),
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a15d36cc50',
                        'label' => __('Use cache', 'xml-wp-query'),
                        'name' => 'xml_wp_query_cache',
                        'type' => 'true_false',
                        'required' => 0,
                        'message' => __('Use cache', 'xml-wp-query'),
                        'default_value' => 0,
                    ),
                    array(
                        'key' => 'field_562a16406cc51',
                        'label' => __('Cache interval', 'xml-wp-query'),
                        'name' => 'xml_wp_query_cache_interval',
                        'type' => 'select',
                        'conditional_logic' => array(
                            'status' => 1,
                            'rules' => array(
                                array(
                                    'field' => 'field_562a15d36cc50',
                                    'operator' => '==',
                                    'value' => '1',
                                ),
                            ),
                            'allorany' => 'all',
                        ),
                        'choices' => array(
                            '1 minute' => __('Update every minute', 'xml-wp-query'),
                            '5 minutes' => __('Update every 5 minutes', 'xml-wp-query'),
                            '15 minutes' => __('Update every 15 minutes', 'xml-wp-query'),
                            '30 minutes' => __('Update every half hour', 'xml-wp-query'),
                            '1 hour' => __('Update every hour', 'xml-wp-query'),
                            '2 hours' => __('Update every other hour', 'xml-wp-query'),
                            '1 day' => __('Update every day', 'xml-wp-query'),
                        ),
                        'default_value' => '',
                        'allow_null' => 0,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_568246099108a',
                        'label' => __('Last update', 'xml-wp-query'),
                        'name' => 'xml_wp_query_cache_last_update',
                        'type' => 'text',
                        'conditional_logic' => array(
                            'status' => 1,
                            'rules' => array(
                                array(
                                    'field' => 'field_562a15d36cc50',
                                    'operator' => '==',
                                    'value' => '1',
                                ),
                            ),
                            'allorany' => 'all',
                        ),
                        'required' => 0,
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_568248612bb52',
                        'label' => __('Update cache', 'xml-wp-query'),
                        'name' => 'xml_wp_query_cache_update_button',
                        'type' => 'message',
                        'conditional_logic' => array(
                            'status' => 1,
                            'rules' => array(
                                array(
                                    'field' => 'field_562a15d36cc50',
                                    'operator' => '==',
                                    'value' => '1',
                                ),
                            ),
                            'allorany' => 'all',
                        ),
                        'message' => '<span id="xml_wp_query-last-update"></span> <button type="button" id="xml_wp_query-update-cache-button">bijwerken</button><img src="http://autonol.nl/wp-content/plugins/contact-form-7/images/ajax-loader.gif" width="16" height="16" style="display:none;" id="xml_wp_query-update-cache-loader"/><script>jQuery(function () {var date = new Date(parseInt(jQuery("#acf-field-xml_wp_query_cache_last_update").val()) * 1000); jQuery("#xml_wp_query-last-update").html(date.toLocaleString()); jQuery("#xml_wp_query-update-cache-button").on("click", function () {var regex = new RegExp("post=([^&#=]*)"); jQuery.ajax({method:"POST", url: "admin-ajax.php", data: {action: "xml_wp_query_update_cache", id: regex.exec(window.location.href)[1]}, dataType: "json", beforeSend: function () {jQuery("#xml_wp_query-update-cache-loader").show();}, complete: function () {jQuery("#xml_wp_query-update-cache-loader").hide();}, success: function (response) {date = new Date(parseInt(response) * 1000); jQuery("#xml_wp_query-last-update").html(date.toLocaleString());}})})});</script>',
                    ),
                    array(
                        'key' => 'field_562a16d36cc52',
                        'label' => __('Item tag', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_tag',
                        'type' => 'text',
                        'required' => 1,
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a170b6cd52',
                        'label' => __('Item - Slug tags', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_slug_tags',
                        'type' => 'text',
                        'required' => 1,
                        'default_value' => '',
                        'placeholder' => '',
                        'instructions' => __('Specify (comma separated) which tags have to be combined to form a slug.', 'xml-wp-query'),
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a170b6cc53',
                        'label' => __('Item - Unique key tag', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_unique_key_tag',
                        'type' => 'text',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a17436cc54',
                        'label' => __('Item - Title tag', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_title_tag',
                        'type' => 'text',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a17aa6cc55',
                        'label' => __('Item - Date tag', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_date_tag',
                        'type' => 'text',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_562a17aa6cc56',
                        'label' => __('Item - Filterable fields', 'xml-wp-query'),
                        'name' => 'xml_wp_query_item_filterable_fields',
                        'type' => 'text',
                        'default_value' => '',
                        'placeholder' => '',
                        'instructions' => __('Specify (comma separated) which tags could be used as filters.', 'xml-wp-query'),
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'xml_wp_query_feed',
                            'order_no' => 0,
                            'group_no' => 0,
                        ),
                    ),
                ),
                'options' => array(
                    'position' => 'normal',
                    'layout' => 'no_box',
                    'hide_on_screen' => array(
                        0 => 'permalink',
                        1 => 'the_content',
                        2 => 'excerpt',
                        3 => 'discussion',
                        4 => 'comments',
                        5 => 'revisions',
                        6 => 'slug',
                        7 => 'author',
                        8 => 'format',
                        9 => 'featured_image',
                    ),
                ),
                'menu_order' => 0,
            ));
        }
    }

    public function register_cache() {
        register_setting('xml-wp-query-settings', 'xml_wp_query_cache_last_update');
    }

}