<?php
/*
Plugin Name: Newsletter by yndenz
Plugin URI:  http://www.yndenz.com
Description: Create newsletters and display them in your own theme style
Version:     1.1.0
Author:      Gido Manders <g.manders@yndenz.com>
Author URI:  http://www.yndenz.com
Domain Path: /languages
Text Domain: newsletter
*/

defined('ABSPATH') or die('No script kiddies please!');

/**
 * Load the text domain for the Newsletter plugin
 */
add_action('plugins_loaded', 'load_newsletter_textdomain');
function load_newsletter_textdomain()
{
    load_plugin_textdomain('newsletter', FALSE, basename(dirname(__FILE__)) . '/languages/');
}

$newsletter = new Newsletter();

class Newsletter
{

    /**
     * Start up
     */
    public function __construct()
    {
        add_action('init', array($this, 'register_newsletter_post_type'));
        add_action('init', array($this, 'register_newsletter_fields'));
    }

    /**
     * Register newsletter fields (2 posts to be displayed in the newsletter)
     */
    function register_newsletter_fields()
    {
        if (function_exists("register_field_group")) {
            $fields = array();
            $num_posts = apply_filters('yndenz_newsletter_num_posts', 5);
            for ($i = 1; $i <= $num_posts; $i++) {
                array_push($fields, array(
                    'key' => 'acf-newsletter_post_' . $i,
                    'label' => sprintf(__('Post %d', 'newsletter'), $i),
                    'name' => 'newsletter_post_' . $i,
                    'type' => 'post_object',
                    'post_type' => array(
                        0 => 'post',
                    ),
                    'taxonomy' => array(
                        0 => 'all',
                    ),
                    'allow_null' => 1,
                    'multiple' => 0,
                ));
            }

            apply_filters('yndenz_newsletter_posts_fields', $fields);

            register_field_group(array(
                'id' => 'acf_newsletters',
                'title' => __('Posts', 'newsletter'),
                'fields' => $fields,
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'newsletter',
                            'order_no' => 0,
                            'group_no' => 0,
                        ),
                    ),
                ),
                'options' => array(
                    'position' => 'normal',
                    'layout' => 'no_box',
                    'hide_on_screen' => array(),
                ),
                'menu_order' => 0,
            ));
        }
    }

    /**
     * Register newsletter post type
     */
    function register_newsletter_post_type()
    {
        register_post_type('newsletter', array(
            'labels' => array(
                'name' => _x('Newsletter', 'post type general name', 'newsletter'),
                'singular_name' => _x('Newsletter', 'post type singular name', 'newsletter'),
                'menu_name' => _x('Newsletters', 'admin menu', 'newsletter'),
                'name_admin_bar' => _x('Newsletter', 'add new on admin bar', 'newsletter'),
                'add_new' => _x('Add new', 'newsletter', 'newsletter'),
                'add_new_item' => __('Add new newsletter', 'newsletter'),
                'new_item' => __('New newsletter', 'newsletter'),
                'edit_item' => __('Edit newsletter', 'newsletter'),
                'view_item' => __('View newsletter', 'newsletter'),
                'all_items' => __('All newsletters', 'newsletter'),
                'search_items' => __('Search newsletters', 'newsletter'),
                'not_found' => __('No newsletters found.', 'newsletter'),
                'not_found_in_trash' => __('No newsletters found in Trash.', 'newsletter')
            ),
            'description' => __('Newsletters', 'newsletter'),
            'taxonomies' => array('category'),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 21,
            'menu_icon' => 'dashicons-media-document',
            'capability_type' => 'post',
            'has_archive' => true,
            'hierarchical' => false,
            'supports' => array('title', 'editor'),
            'rewrite' => array(
                'slug' => 'nieuwsbrieven',
                'with_front' => true,
                'feeds' => true,
                'pages' => true
            )
        ));
    }
}