<?php
/*
Plugin Name: yndenz Raw HTML
Plugin URI:  http://www.yndenz.com
Description: Plugin voor het verkrijgen van HTML voor het kopieren van bijvoorbeeld nieuwsbrieven naar YMLP of MailChimp.
Version: 1.1.2
Author: yndenz BV
Author URI: http://www.yndenz.com/
Domain Path: /languages
Text domain: raw-html
*/

add_action('admin_menu', 'html_wp_admin_pages');
function html_wp_admin_pages() {
    add_menu_page(__('Copy HTML-code (i.e. a newsletter) and paste it in YMLP or MailChimp', 'raw-html'), 'HTML', 'read', 'html', 'load_page');
}

function load_page() {
    ?>
    <div id="icon-edit" class="icon32 icon32-posts-post"><br></div>
    <h2><?php _e('HTML', 'raw-html'); ?></h2>
    <p><?php _e('Use this plugin to copy HTML-code for use in YMLP or MailChimp.', 'raw-html'); ?></p>
    <?php
    if (array_key_exists('output', $_GET)) {
        show_output();
    } else {
        show_form();
    }
}

function show_form() {
    $template = locate_template('yndenz-raw-html-form.php');
    if (empty($template)) {
        $template = __DIR__ . '/yndenz-raw-html-form.php';
    }
    include $template;
}

function show_output() {
    ?>
    <p><button type="button" class="copy-to-clipboard"><?php _e('Copy to clipboard', 'raw-html'); ?></button></p>
    <iframe src="<?php echo $_GET['output']; ?>" style="width:650px;height:1750px;padding:15px;background: #fff;" id="raw-html-frame"></iframe>
    <textarea id="raw-html" style="position:fixed;top:0;left:0;width:2em;height:2em;padding:0;border:none;outline:none;box-shadow:none;background:transparent;"></textarea>
    <script type="text/javascript">
        var aux;

        jQuery(function () {
            aux = jQuery('#raw-html');

            jQuery('.copy-to-clipboard').on('click', function () {
                try {
                    getHTMLContent();
                    copyToClipboard();
                    console.log('<?php _e('Copied to clipboard successfully', 'raw-html'); ?>');
                } catch (err) {
                    window.prompt('<?php _e('Copy to clipboard failed. Please use CTR + C or CMD + C to copy the following manually.', 'raw-html'); ?>', html);
                }
            });
        });

        function getHTMLContent() {
            var html = jQuery('#raw-html-frame').contents().find("html").prop('outerHTML');
            aux.val(html);
        }

        function copyToClipboard() {
            aux.select();

            if (!document.execCommand('copy')) throw "failed";
        }
    </script>
    <?php
}
