#!/bin/bash

function bumpMainPluginFile {
    version=$2
    search='("YNDENZ_SECURE_LOGIN_VERSION",[[:space:]]*").+(")'
    replace="\1${version}\2"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"

    search='(Version:[[:space:]]*).+'
    replace="\1${version}"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"
    rm "$1.tmp"
}
function bumpReadmeFile {
    version=$2
    search='(Stable tag: ).+'
    replace="\1${version}"

    sed -i ".tmp" -E "s/${search}/${replace}/g" "$1"
    rm "$1.tmp"
}

composer update

version=$(composer config version)

bumpMainPluginFile yndenz-secure-login.php $version

git add -A
git commit -m "Release ${version}"
git tag $version
git push
git push --tags