<?php

class YSL_Core {

	private static $instance;

	public static function getInstance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function init() {
		add_action( 'init', array( $this, 'performKeyCheck' ) );
		add_action( 'admin_menu', array( $this, 'addMenuItem' ) );
		add_filter( 'logout_url', array( $this, 'addQueryParam' ), 101, 1 );
		add_filter( 'wp_logout', array( $this, 'redirectLogout' ) );
	}

	public function redirectLogout() {
		$url = esc_url( home_url( '/ynlog' ) );
		wp_redirect( $url );
		exit();
	}

	public function performKeyCheck() {
		if ( strpos( strtolower( $_SERVER['REQUEST_URI'] ), '/wp-admin/' ) !== false ) {
			if ( ! is_user_logged_in() ) {
				$this->blockAccess();
			}
		}
		if ( ! ( ( isset( $_GET['login_key'] ) && $_GET['login_key'] == get_option( 'ysl_login_key', 'admyn' ) ) ) ) {
			if ( strpos( strtolower( $_SERVER['REQUEST_URI'] ), '/wp-login.php' ) !== false ) {
				if ( ! ( $_SERVER['REQUEST_METHOD'] === 'POST' && $_SERVER['HTTP_REFERER'] === home_url( '/ynlog' ) ) ) {
					$this->blockAccess();
				}
			}
		}
	}

	public function blockAccess() {
		$url = esc_url( home_url() );
		wp_redirect( $url );
		exit;
	}

	public function addQueryParam( $url ) {
		$user = wp_get_current_user();
		if ( isset( $user->roles[0] ) ) {
			if ( $user->roles[0] == 'administrator' ) {
				if ( $url ) {
					return add_query_arg( 'login_key', get_option( 'ysl_login_key', 'admyn' ), $url );
				}
			}
		}

		return $url;
	}

	public function addMenuItem() {
		add_options_page(
			'Yndenz Secure Login',
			'Yndenz Secure Login',
			'manage_options',
			'yndenz-secure-login',
			array( $this, 'optionsPage' )
		);
	}

	public function optionsPage() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'You do not have the sufficient permissions to view this page.' );
		}

		if ( isset( $_POST['update'] ) ) {
			if ( ! wp_verify_nonce( $_REQUEST['_wpnonce'], 'ysl-settings-update' ) ) {
				wp_die( 'Security check failed.' );
			}
			update_option( 'ysl_login_key', sanitize_text_field( trim( $_POST['ysl_login_key'] ) ) );
			$options['updated'] = 1;
		}

		$options['login-key'] = get_option( 'ysl_login_key', 'admyn' );
		include dirname( __FILE__ ) . '/templates/options-page.php';
	}

}
